/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.util.ProcessStatus;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SwitchBranchHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        String currentBranch = repo.currentBranch();
        ArrayList<MenuDialogItem> listOfMaps = new ArrayList<MenuDialogItem>();
        for (String branch : repo.localBranches()) {
            if (branch.equals(currentBranch)) continue;
            listOfMaps.add(new MenuDialogItem(branch));
        }
        if (!listOfMaps.isEmpty()) {
            QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.SwitchBranchHandler_PopupTitle);
            dialog.setInput(listOfMaps);
            if (dialog.open() != -1) {
                MenuDialogItem item = (MenuDialogItem)listOfMaps.get(dialog.getReturnCode());
                SwitchBranchHandler.switchBranch(repo, item.getText());
            }
        }
        return null;
    }

    public static void switchBranch(GitRepository repo, String branchName) {
        String text = MessageFormat.format(Messages.SwitchBranchAction_BranchSwitch_Msg, branchName);
        IStatus switchStatus = repo.switchBranch(branchName, (IProgressMonitor)new NullProgressMonitor());
        if (!switchStatus.isOK()) {
            text = switchStatus instanceof ProcessStatus ? ((ProcessStatus)switchStatus).getStdErr() : switchStatus.getMessage();
        }
        final Shell shell = UIUtils.getActiveShell();
        DefaultToolTip toolTip = new DefaultToolTip((Control)shell){

            public Point getLocation(Point size, Event event) {
                Rectangle workbenchWindowBounds = shell.getBounds();
                int xCoord = workbenchWindowBounds.x + workbenchWindowBounds.width - size.x - 10;
                int yCoord = workbenchWindowBounds.y + workbenchWindowBounds.height - size.y - 10;
                return new Point(xCoord, yCoord);
            }
        };
        toolTip.setHideDelay(3000);
        toolTip.setText(text);
        toolTip.show(new Point(0, 0));
    }
}

